; -------------------------------------------------------------------------------------------------------------- ;
; Bounty Bob Strikes Back Original (Copy Protected) - dat.prg
; -------------------------------------------------------------------------------------------------------------- ;
; called from: a --> dat
;   load pgm : bob-data
;   load pgm : bob-load
;   call pgm : --> bob-load
;   load pgm : bounty-bob
;   call pgm : --> bounty bob --> BountyBobStart
; -------------------------------------------------------------------------------------------------------------- ;
                        * equ $0e00
; -------------------------------------------------------------------------------------------------------------- ;
; compiler settings
; -------------------------------------------------------------------------------------------------------------- ;
                        incdir  ..\inc                    ; C64 System Includes

C64Kernal               include c64_kernal.asm            ; Kernal Routines entry points                  $e000-$ffff
C64Memory               include c64_mem.asm               ; Standard Zeropage / Stack / Vector constants
; -------------------------------------------------------------------------------------------------------------- ;
; External Addresses
; -------------------------------------------------------------------------------------------------------------- ;
EntryPoint_BountyBob    = $2e64                           ; BountyBob module entry point
EntryPoint_BobLoad      = $0845                           ; Bob-Load  module entry point
; -------------------------------------------------------------------------------------------------------------- ;
; Dat_Main              Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
Dat_Main                subroutine                        ; 
                        lda #$ff                          ; 
                        sta FRETOP                        ; Pointer: Bottom of String space
                        sta MEMSIZ                        ; Pointer: Highest Address available to BASIC ($A000)
                        
                        lda #$1f                          ; 
                        sta [FRETOP + $01]                ; Pointer: Bottom of String space
                        sta [MEMSIZ + $01]                ; Pointer: Highest Address available to BASIC ($A000)
                        
.IniLoadFiles           lda #$0f                          ; logical file number
                        tay                               ; secondary command number ($00 = new load address)
                        ldx #$08                          ; device number
                        jsr SETLFS                        ; Kernel($FFBA) Set logical file parameters ($FE00)
                        
.LoadFileBobDataName    lda #FileNamesBobDataLen          ; load bob-data
                        ldx #<FileNamesBobData            ; 
                        ldy #>FileNamesBobData            ; 
                        jsr SETNAM                        ; Kernel($FFBD) Set filename parameters ($FDF9)
                        
.LoadFileBobData        lda #$00                          ; flag: load
                        jsr LOAD                          ; Kernel($FFD5) Load from device (via $330 to $F49E)
                        
.LoadFileBobLoadName    lda #FileNamesBobLoadLen          ; load bob-load
                        ldx #<FileNamesBobLoad            ; 
                        ldy #>FileNamesBobLoad            ; 
                        jsr SETNAM                        ; Kernel($FFBD) Set filename parameters ($FDF9)
                        
.LoadFileBobLoad        lda #$00                          ; flag: load
                        jsr LOAD                          ; Kernel($FFD5) Load from device (via $330 to $F49E)
                        
.NewFastLoad_Install    jsr EntryPoint_BobLoad            ; 
                        
.LoadFileBoBoName       lda #FileNamesBoBoLen             ; load bounty bob
                        ldx #<FileNamesBoBo               ; 
                        ldy #>FileNamesBoBo               ; 
                        jsr SETNAM                        ; Kernel($FFBD) Set filename parameters ($FDF9)
                        
.LoadFileBoBo           lda #$00                          ; flag: load
.NewFastLoad_Use        jsr LOAD                          ; Now new: Kernel($FFD5) Load from device (via $330 to $F49E)
                        
Dat_MainX               jmp EntryPoint_BountyBob          ; 
; -------------------------------------------------------------------------------------------------------------- ;
FileNames               equ  *                            ; 
FileNamesBobData        text "bob-data"                   ; 
FileNamesBobDataLen     equ  [* - FileNamesBobData]       ; 
                        
FileNamesBobLoad        text "bob-load"                   ; 
FileNamesBobLoadLen     equ  [* - FileNamesBobLoad]       ; 
                        
FileNamesBoBo           text "bounty bob"                 ; 
FileNamesBoBoLen        equ  [* - FileNamesBoBo]          ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $ff ; 
; -------------------------------------------------------------------------------------------------------------- ;
